<?php
include "../../../assets/php/connection.php";

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['upload_profile'])) {
    $user_id = $_POST['user_id'] ?? null;

    if (!$user_id || !isset($_FILES['profile_pic'])) {
        header("Location: ../../profile.php?message=" . urlencode("Invalid request.") . "&message_type=error");
        exit();
    }

    // Upload directory
    $upload_dir = '../uploads/profile_pics/';
    if (!file_exists($upload_dir)) {
        mkdir($upload_dir, 0777, true);
    }

    // Upload handler
    function uploadProfilePic($file, $upload_dir, $prefix) {
        $filename = $prefix . '_' . time() . '_' . basename($file['name']);
        $target_file = $upload_dir . $filename;

        // Validate file type
        $allowed_types = ['image/jpeg', 'image/png', 'image/jpg'];
        if (!in_array($file['type'], $allowed_types)) {
            return false;
        }

        // Validate file size (max 5MB)
        if ($file['size'] > 5 * 1024 * 1024) {
            return false;
        }

        if (move_uploaded_file($file['tmp_name'], $target_file)) {
            return $filename;
        }

        return false;
    }

    $profile_pic = uploadProfilePic($_FILES['profile_pic'], $upload_dir, 'profile');

    if ($profile_pic) {
        // Save filename in the user table (adjust table/column name if needed)
        $stmt = $conn->prepare("UPDATE users SET profile_picture = ? WHERE id = ?");
        $stmt->bind_param("si", $profile_pic, $user_id);

        if ($stmt->execute()) {
            header("Location: ../../upload.php?message=" . urlencode("Profile picture updated successfully.") . "&message_type=success");
            exit();
        } else {
            header("Location: ../../upload.php?message=" . urlencode("Database error. Try again.") . "&message_type=error");
            exit();
        }
        $stmt->close();
    } else {
        header("Location: ../../upload.php?message=" . urlencode("Upload failed. Only JPG/PNG images under 5MB allowed.") . "&message_type=error");
        exit();
    }
    $conn->close();
}
