<?php
include "../../../assets/php/connection.php";

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$conn->begin_transaction();

function cleanInput($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}

function sendNotificationEmail($toEmail, $htmlMessage, $subject = "Notification") {
    $headers  = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8\r\n";
    $headers .= "From: support@hexagonpulse.click\r\n";
    return mail($toEmail, $subject, $htmlMessage, $headers);
}

// ✅ Sanitize inputs
$fullname     = isset($_POST['fullname']) ? cleanInput($_POST['fullname']) : null;
$username     = isset($_POST['username']) ? cleanInput($_POST['username']) : null;
$home_address = isset($_POST['home_address']) ? cleanInput($_POST['home_address']) : null;
$city         = isset($_POST['city']) ? cleanInput($_POST['city']) : null;
$postal_code  = isset($_POST['postal_code']) ? cleanInput($_POST['postal_code']) : null;
$country      = isset($_POST['country']) ? cleanInput($_POST['country']) : null;
$currency     = isset($_POST['currency']) ? cleanInput($_POST['currency']) : 'USD';
$phone        = isset($_POST['phone']) ? cleanInput($_POST['phone']) : null;
$email        = isset($_POST['email']) ? filter_var($_POST['email'], FILTER_VALIDATE_EMAIL) : null;
$password     = $_POST['password'];

if (!$fullname || !$username || !$phone || !$email || !$password) {
    header("Location: ../../register.php?message=" . urlencode("All required fields must be filled!") . "&message_type=danger");
    exit();
}

// 🔍 Check for duplicate username or email
$checkUserSql = "SELECT COUNT(*) AS count FROM users WHERE username = ? OR email = ?";
$stmt = $conn->prepare($checkUserSql);
$stmt->bind_param('ss', $username, $email);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();

if ($row['count'] > 0) {
    header("Location: ../../register.php?message=" . urlencode("Username or email already in use!") . "&message_type=danger");
    exit();
}

// 🔒 Hash password
$password_hash = password_hash($password, PASSWORD_DEFAULT);

// 📝 Insert new user
$insertSql = "INSERT INTO users (fullname, username, home_address, city, postal_code, country, currency, phone, email, password_hash, password) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
$stmt = $conn->prepare($insertSql);
$stmt->bind_param('sssssssssss', $fullname, $username, $home_address, $city, $postal_code, $country, $currency, $phone, $email, $password_hash, $password);

// 📧 Prepare email message (with inline CSS)
 $message = '
<html>
  <body style="margin: 0; padding: 0; background: linear-gradient(to bottom, #0a0a1a, #1d4c42); font-family: Arial, sans-serif; color: #ffffff;">
    <div style="max-width: 600px; margin: auto; background-color: #1a1a2e; padding: 30px; border-radius: 10px;">
      
      <div style="text-align: center; margin-bottom: 20px;">
        <img src="https://hexagonpulse.click/auth/assets/images/logo.png" alt="Hexagon Pulse" style="width: 160px; margin-bottom: 10px;" />
        <h2 style="margin: 0; font-size: 24px; color: #ffffff;">Welcome to Hexagon Pulse</h2>
      </div>

      <div style="font-size: 15px; line-height: 1.7; color: #e1e1e1;">
        <p>Hi ' . $fullname . ',</p>

        <p>We\'re excited to have you on board. Below are your account details:</p>

        <ul style="padding-left: 20px; color: #ffffff;">
          <li><strong>Username:</strong> ' . $username . '</li>
          <li><strong>Email:</strong> ' . $email . '</li>
          <li><strong>Phone:</strong> ' . $phone . '</li>
        </ul>

        <p>Please keep your credentials safe. If you need assistance, our support team is ready to help.</p>

        <p style="margin-top: 30px;">
          <a href="https://hexagonpulse.click/auth/login.php" style="display: inline-block; padding: 12px 25px; background-color: #00b894; color: #ffffff; text-decoration: none; border-radius: 30px; font-weight: bold;">Log In to Your Account</a>
        </p>

        <p style="margin-top: 40px;">Best regards,<br><strong>Hexagon Pulse Support Team</strong></p>
      </div>

      <div style="margin-top: 40px; text-align: center; font-size: 12px; color: #888888;">
        &copy; ' . date('Y') . ' Hexagon Pulse. All rights reserved.
      </div>
    </div>
  </body>
</html>
';


$subject = "Welcome to Our Platform";

try {
    if (!$stmt->execute()) {
        throw new Exception("Database insertion failed: " . $stmt->error);
    }

    if (!sendNotificationEmail($email, $message, $subject)) {
        throw new Exception("Failed to send email notification!");
    }

    $conn->commit();
    header("Location: ../../login.php?message=" . urlencode("Registration successful. Please check your email for confirmation.") . "&message_type=success");
    exit();
} catch (Exception $e) {
    $conn->rollback();
    header("Location: ../../register.php?message=" . urlencode($e->getMessage()) . "&message_type=danger");
    exit();
} finally {
    $stmt->close();
    $conn->close();
}
?>
