<?php
require 'config/connection.php';
require 'send_email.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validate input
    if (!isset($_POST['user_id']) || !ctype_digit($_POST['user_id']) || !isset($_POST['kyc_num'])) {
        $message = "Invalid request!";
        $type = "error";
        header("Location: ../../verifications.php?message=" . urlencode($message) . "&type=" . urlencode($type));
        exit();
    }

    $user_id = intval($_POST['user_id']);
    $kyc_num = intval($_POST['kyc_num']);
    $user_email = $_POST['user_email'];
    
    if ($kyc_num == 1) {
        $kyc_status = 'approved';
    } else {
        $kyc_status = 'rejected';
    }

    if (!$user_id) {
        $message = "User not found!";
        $type = "error";
        header("Location: ../../verifications.php?message=" . urlencode($message) . "&type=" . urlencode($type));
        exit();
    }

    // Update KYC status in kyc_verifications table
    $stmt = $conn->prepare("UPDATE kyc_verifications SET status = ? WHERE user_id = ?");
    $stmt->bind_param("si", $kyc_status, $user_id);
    
    if ($stmt->execute()) {
        if ($kyc_status == 'approved') { // Approved: Set user as verified
            $verified = 1;
            $stmt2 = $conn->prepare("UPDATE users SET verified = ? WHERE id = ?");
            $stmt2->bind_param("ii", $verified, $user_id);
            $stmt2->execute();
            $stmt2->close();

            $message = "KYC approved & user verified!";
            $email_subject = "KYC Verification Approved";
            $email_body = "Dear User,\n\nYour KYC verification has been approved. Your account is now fully verified.\n\nBest Regards,\nSupport Team";
        } else { // Rejected: Set user as unverified
            $verified = 0;
            $stmt2 = $conn->prepare("UPDATE users SET verified = ? WHERE id = ?");
            $stmt2->bind_param("ii", $verified, $user_id);
            $stmt2->execute();
            $stmt2->close();

            $message = "KYC rejected & user unverified.";
            $email_subject = "KYC Verification Rejected";
            $email_body = "Dear User,\n\nUnfortunately, your KYC verification was rejected. Please re-upload the required documents.\n\nBest Regards,\nSupport Team";
        }

        // Send email notification
        sendNotificationEmail($user_email, $email_body, $email_subject);

        $type = "success";
    } else {
        $message = "Error updating KYC status!";
        $type = "error";
    }

    $stmt->close();
    $conn->close();

    header("Location: ../../verifications.php?message=" . urlencode($message) . "&type=" . urlencode($type));
    exit();
}
