<?php
require 'config/connection.php';
require 'send_email.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validate required fields
    if (
        !isset($_POST['transaction_id']) || !ctype_digit($_POST['transaction_id']) ||
        !isset($_POST['user_id']) || !ctype_digit($_POST['user_id']) ||
        !isset($_POST['amount']) || !is_numeric($_POST['amount']) ||
        // !isset($_POST['notification_id']) || !ctype_digit($_POST['notification_id'])
        !isset($_POST['username'])
    ) {
        $message = "Invalid or missing required fields!";
        $type = "error";
        header("Location: ../../withdraw.php?message=" . urlencode($message) . "&type=" . urlencode($type));
        exit();
    }

    // Assign variables
    $transaction_id = intval($_POST['transaction_id']);
    $user_id = intval($_POST['user_id']);
    $amount = floatval($_POST['amount']);
    // $notification_id = intval($_POST['notification_id']);
    $username = $_POST['username'];
    $action = $_POST['action'];

    // Validate action type
    if (!in_array($action, ['approve', 'decline'])) {
        $message = "Invalid action!";
        $type = "error";
        header("Location: ../../withdraw.php?message=" . urlencode($message) . "&type=" . urlencode($type));
        exit();
    }

    // Start MySQL transaction
    $conn->begin_transaction();

    try {
        // ✅ Fetch User profit_balance
        $checkprofit_balance = $conn->prepare("SELECT profit_balance, email FROM users WHERE id = ?");
        $checkprofit_balance->bind_param("i", $user_id);
        $checkprofit_balance->execute();
        $checkprofit_balance->bind_result($current_profit_balance, $user_email);
        $checkprofit_balance->fetch();
        $checkprofit_balance->close();


        if ($action === 'approve') {
            if ($current_profit_balance < $amount) {
                // ❌ Automatically decline if profit_balance is insufficient
                $status = 'declined';
                $message = "Withdrawal declined due to insufficient profit_balance!";
            } else {
                // ✅ Approve the withdrawal
                $status = 'approved';

                // Deduct from User profit_balance
                $updateprofit_balance = $conn->prepare("UPDATE users SET profit_balance = profit_balance - ? WHERE id = ?");
                $updateprofit_balance->bind_param("di", $amount, $user_id);
                if (!$updateprofit_balance->execute()) {
                    throw new Exception("Error updating user profit_balance!");
                }
                $updateprofit_balance->close();

                $message = "Withdrawal approved successfully!";
            }
        } else {
            $status = 'declined';
            $message = "Withdrawal declined successfully!";
        }

        // ✅ Update Withdrawal Transaction Status
        $updateTransaction = $conn->prepare("UPDATE transactions SET status = ? WHERE id = ?");
        $updateTransaction->bind_param("si", $status, $transaction_id);
        if (!$updateTransaction->execute()) {
            throw new Exception("Error updating withdrawal status!");
        }
        $updateTransaction->close();

        // // ✅ Mark Notification as Read
        // $markNotification = $conn->prepare("UPDATE notifications SET status = 'read' WHERE id = ?");
        // $markNotification->bind_param("i", $notification_id);
        // if (!$markNotification->execute()) {
        //     throw new Exception("Error marking notification as read!");
        // }
        // $markNotification->close();

        // ✅ Insert New Notification
        $notification_message = "Your withdrawal request of $$amount has been " . ucfirst($status);
        $insertNotification = $conn->prepare("INSERT INTO notifications (user_id, user_name, message, recipient_type, status) VALUES (?, ?, ?, 'user', 'unread')");
        $insertNotification->bind_param("iss", $user_id, $username, $notification_message);
        if (!$insertNotification->execute()) {
            throw new Exception("Error inserting notification!");
        }
        $insertNotification->close();
        
        if (!sendNotificationEmail($user_email, $notification_message, "Withdrawal Request Status Update")) {
            throw new Exception("Failed to send email notification!");
        }

        // Commit the transaction if all queries succeed
        $conn->commit();
        $type = "success";
    } catch (Exception $e) {
        // Rollback transaction if any query fails
        $conn->rollback();
        $message = $e->getMessage();
        $type = "error";
    }

    $conn->close();
    header("Location: ../../withdraw.php?message=" . urlencode($message) . "&type=" . urlencode($type));
    exit();
}
