<?php
require 'config/connection.php'; // Include DB connection

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $trader_name = trim($_POST['trader_name']);
    $win_rate = floatval($_POST['win_rate']);
    $profit_percent = floatval($_POST['profit_percent']);

    // Validate base inputs
    if (empty($trader_name) || $win_rate <= 0 || $profit_percent <= 0 || !isset($_FILES['trader_image'])) {
        $message = "Invalid input. Please check your entries.";
        $type = "danger";
    } else {
        // Handle image upload
        $upload_dir = "../../assets/images/";
        $image = $_FILES['trader_image'];
        $image_name = basename($image['name']);
        $image_tmp = $image['tmp_name'];
        $image_size = $image['size'];
        $image_ext = strtolower(pathinfo($image_name, PATHINFO_EXTENSION));
        $allowed_exts = ['jpg', 'jpeg', 'png', 'gif', 'webp'];

        // Validate image
        if (!in_array($image_ext, $allowed_exts)) {
            $message = "Invalid image format. Allowed: JPG, PNG, GIF, WEBP.";
            $type = "danger";
        } elseif ($image_size > 2 * 1024 * 1024) { // 2MB limit
            $message = "Image is too large. Max 2MB.";
            $type = "danger";
        } else {
            // Create unique filename
            $unique_name = uniqid("trader_", true) . '.' . $image_ext;
            $target_path = $upload_dir . $unique_name;

            if (move_uploaded_file($image_tmp, $target_path)) {
                // Save to DB
                $stmt = $conn->prepare("INSERT INTO copy_traders (trader_name, win_rate, profit_percent, image_url) VALUES (?, ?, ?, ?)");
                $stmt->bind_param("sdds", $trader_name, $win_rate, $profit_percent, $unique_name);

                if ($stmt->execute()) {
                    $message = "Trader added successfully!";
                    $type = "success";
                } else {
                    $message = "Database error: Could not add trader.";
                    $type = "danger";
                }

                $stmt->close();
            } else {
                $message = "Failed to upload image.";
                $type = "danger";
            }
        }
    }

    $conn->close();
    header("Location: ../../copy_traders.php?message=" . urlencode($message) . "&type=" . urlencode($type));
    exit();
}
?>
